using System;

namespace Server.Items
{

	public abstract class BaseSilkWaist : BaseClothing
	{
		public BaseSilkWaist( int itemID ) : this( itemID, 0 )
		{
		}

		public BaseSilkWaist( int itemID, int hue ) : base( itemID, Layer.Waist, hue )
		{
		}

        public BaseSilkWaist(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x153b, 0x153c )]
	public class SilkHalfApron : BaseSilkWaist
	{
        public override int BasePhysicalResistance { get { return 1; } }
        public override int BaseFireResistance { get { return 4; } }
        public override int BaseColdResistance { get { return 1; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 0; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkHalfApron() : this( 0 )
		{
		}

		[Constructable]
		public SilkHalfApron( int hue ) : base( 0x153b, hue )
		{
			Weight = 2.0;
            Name = "Silk Half Apron";
		}

        public SilkHalfApron(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x27A0, 0x27EB )]
    public class SilkObi : BaseSilkWaist
	{
        public override int BasePhysicalResistance { get { return 1; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 1; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkObi() : this( 0 )
		{
		}

		[Constructable]
		public SilkObi( int hue ) : base( 0x27A0, hue )
		{
			Weight = 1.0;
            Name = "Silk Obi";
		}

        public SilkObi(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x2B68, 0x315F )]
	public class SilkWoodlandBelt : BaseSilkWaist
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 3; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkWoodlandBelt() : this( 0 )
		{
		}

		[Constructable]
		public SilkWoodlandBelt( int hue ) : base( 0x2B68, hue )
		{
			Weight = 4.0;
            Name = "Woodland Silk Belt";
		}

        public SilkWoodlandBelt(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
}
